(*
  Interface to the simple resampler. See resample.c, resample.h files for more details.
 *)

unit resample;

{$L resample.obj}

interface

type

  SAMPLE = Single;
  PSAMPLE = ^SAMPLE;

function _res_init(var res_state : Pointer; channels, outfreq, infreq : Integer; res_parameter : Integer) : Integer; cdecl; external;
procedure _res_clear(res_state : Pointer); cdecl; external;

function _res_push_check(res_state : Pointer; srclen : LongWord) : Integer; cdecl; external;
function _res_push_max_input(res_state : Pointer; maxoutput : LongWord) : Integer; cdecl; external;
function _res_push_interleaved(res_state : Pointer; dest, source : PSAMPLE; srclen : LongWord) : Integer; cdecl; external;
function _res_drain_interleaved(res_state : Pointer; dest : PSAMPLE) : Integer; cdecl; external;

implementation

var
  __turboFloat : Double;

function _sin(x : Double) : Double; cdecl;
begin
  Result := Sin(x);
end;

function _sqrt(x : Double) : Double; cdecl;
begin
  Result := Sqrt(x);
end;

function _calloc(nelem, size : LongWord) : Pointer; cdecl;
var
  _s : LongWord;
begin
  _s := nelem*size;
  GetMem(Result, _s);
  FillChar(Result^, _s, 0);
end;

procedure _free(p : Pointer); cdecl;
begin
  FreeMem(p);
end;

function _malloc(size : LongWord) : Pointer; cdecl;
begin
   GetMem(Result, size);
end;

function __assert(v : Integer) : LongBool; cdecl;
begin
  Result := v <> 0;
end;

(*function _memset(s : PByte; c : Integer; n : LongWord) : Pointer; cdecl;
begin
  FillChar(s^, n, c);
  Result := s;
end; *)

end.











