(*
  This file is mp3decdr.dll header translation. See the file
  mp3dec.h for more info
  (c) 2007 Andrei Borovsky <anb@symmetrica.net>
*)

(* $Revision: 1.2 $ $Date: 2007/07/07 01:46:48 $ *) 

unit mp3decdr;

interface

uses
  SysUtils, Windows;

const

  Libmp3decdrPath = 'mp3decdr.dll';

  SEEK_CUR = 1;
  SEEK_END = 2;
  SEEK_SET = 0;

  MP3DEC_RETCODE_OK  =              0;
  MP3DEC_RETCODE_INVALID_HANDLE =   1;
  MP3DEC_RETCODE_BAD_STATE =        2;
  MP3DEC_RETCODE_INVALID_PARAMETERS = 3;
  MP3DEC_RETCODE_NOT_MPEG_STREAM =  4;
  MP3DEC_RETCODE_SEEK_FAILED =      5;
  MP3DEC_RETCODE_UNKNOWN  =         6;

  MP3DEC_CONFIG_AUTO =     0;
  MP3DEC_CONFIG_MONO =     1;
  MP3DEC_CONFIG_STEREO =   2;
  MP3DEC_CONFIG_CHANNEL1 = 3;
  MP3DEC_CONFIG_CHANNEL2 = 4;

  MP3DEC_CONFIG_16BIT = 0;
  MP3DEC_CONFIG_24BIT = 1;
  MP3DEC_CONFIG_32BIT = 2;
  MP3DEC_CONFIG_FLOAT = 3;

  MP3DEC_SEEK_BYTES = 0;
  MP3DEC_SEEK_SAMPLES = 1;
  MP3DEC_SEEK_SECONDS = 2;


type

  mp3dec_t = Pointer;
  mp3dec_config_t = Pointer;

  // callbacks
  seek_func = function(cb_data : Pointer; offset : Integer; origin : Integer) : Integer; cdecl;
  read_func = function(cb_data : Pointer; buf : Pointer; bufsize : Integer) : Integer; cdecl;
  close_func = function(cb_data : Pointer) : Integer; cdecl;

  mp3dec_init_t = function : mp3dec_t; cdecl;
  mp3dec_init_file_t = function(mp3dec : mp3dec_t; cb_data : Pointer; seek : seek_func; read : read_func; close : close_func; length : Int64; nogap : Integer) : Integer; cdecl;
  mp3dec_uninit_t = function(mp3dec : mp3dec_t) : Integer; cdecl;
  mp3dec_reset_t = function(mp3dec : mp3dec_t) : Integer; cdecl;
  mp3dec_configure_t = function(mp3dec : mp3dec_t; cfg : mp3dec_config_t) : Integer; cdecl;
//  int mp3dec_get_info(mp3dec_t mp3dec, void *info, int info_type);
  mp3dec_decode_t = function(mp3dec : mp3dec_t; buf : PByte; bufsize : LongWord; var used : LongWord) : Integer; cdecl;
  mp3dec_seek_t = function(mp3dec : mp3dec_t; pos : Int64; units : Integer) : Integer; cdecl;
  mp3dec_error_t = function(code : Integer) : PChar; cdecl;
  mp3dec_set_config_t = function(mp3dec : mp3dec_t; mode, format : Integer) : Integer; cdecl;
  mp3dec_get_stream_info_t = function(mp3dec : mp3dec_t; var channels : Integer; var sample_rate : Integer; var sample_size : Integer; var samples : Integer) : Integer; cdecl;
  mp3dec_get_file_info_t = function(mp3dec : mp3dec_t; var bitrate : Integer; var layer : Integer) : Integer; cdecl;

var

  Libmp3decdrLoaded : Boolean = False;

  mp3dec_init : mp3dec_init_t;
  mp3dec_init_file : mp3dec_init_file_t;
  mp3dec_uninit : mp3dec_uninit_t;
  mp3dec_reset : mp3dec_reset_t;
  mp3dec_configure : mp3dec_configure_t;
  mp3dec_decode : mp3dec_decode_t;
  mp3dec_seek : mp3dec_seek_t;
  mp3dec_error : mp3dec_error_t;
  mp3dec_set_config : mp3dec_set_config_t;
  mp3dec_get_stream_info : mp3dec_get_stream_info_t;
  mp3dec_get_file_info : mp3dec_get_file_info_t;


implementation

var
  Libhandle : HMODULE;

initialization

  Libhandle := LoadLibraryEx(Libmp3decdrPath, 0, 0);
  if Libhandle <> 0 then
  begin
    Libmp3decdrLoaded := True;
    mp3dec_init := GetProcAddress(Libhandle, 'mp3dec_init');
    mp3dec_init_file := GetProcAddress(Libhandle, 'mp3dec_init_file');
    mp3dec_uninit := GetProcAddress(Libhandle, 'mp3dec_uninit');
    mp3dec_reset := GetProcAddress(Libhandle, 'mp3dec_reset');
    mp3dec_configure := GetProcAddress(Libhandle, 'mp3dec_configure');
    mp3dec_decode := GetProcAddress(Libhandle, 'mp3dec_decode');
    mp3dec_seek := GetProcAddress(Libhandle, 'mp3dec_seek');
    mp3dec_error := GetProcAddress(Libhandle, 'mp3dec_error');
    mp3dec_set_config := GetProcAddress(Libhandle, 'mp3dec_set_config');
    mp3dec_get_stream_info := GetProcAddress(Libhandle, 'mp3dec_get_stream_info');
    mp3dec_get_file_info := GetProcAddress(Libhandle, 'mp3dec_get_file_info');
  end;

finalization

  if libhandle <> 0 then FreeLibrary(Libhandle);


end.
