(*
 ACS Wav to Ogg file converter.
 Copyright (c) Andrei Borovsky
 You can contact me at anb@symmetrica.net
 You will need Ogg Vorbis codec libraries to
 run this demo.
*)

unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ACS_Classes, ACS_Wave, Spin, ACS_Vorbis,
  ExtCtrls;

type
  TForm1 = class(TForm)
    WaveIn1: TWaveIn;
    VorbisOut1: TVorbisOut;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Button1: TButton;
    ProgressBar1: TProgressBar;
    TrackBar1: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    SpinEdit1: TSpinEdit;
    Label4: TLabel;
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    Memo1: TMemo;
    Label5: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure VorbisOut1Done(Sender: TComponent);
    procedure VorbisOut1Progress(Sender: TComponent);
    procedure FormCreate(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  S : String;
  i : Integer;
begin
  If OpenDialog1.Execute then
  begin
    WaveIn1.FileName := OpenDialog1.FileName;
    S := OpenDialog1.FileName;
    SetLength(S, Length(S) - 4);
    SaveDialog1.FileName := S + '.ogg';
    if SaveDialog1.Execute then
    begin
      VorbisOut1.FileName := SaveDialog1.FileName;
      VorbisOut1.Compression := SpinEdit1.Value/10;
      VorbisOut1.Comments.Clear;
      for i := 0 to Memo1.Lines.Count -1 do
      begin
        VorbisOut1.Comments.Add(Memo1.Lines[i]);
      end;
      Button1.Enabled := False;
      VorbisOut1.Run;
      StatusBar1.Panels[0].Text := 'Converting to ' + ExtractFileName(VorbisOut1.FileName);
    end;
  end;
end;

procedure TForm1.VorbisOut1Done(Sender: TComponent);
begin
  Button1.Enabled := True;
  ProgressBar1.Position := 0;
  if VorbisOut1.ExceptionMessage = '' then
    StatusBar1.Panels[0].Text := 'Converted ' + ExtractFileName(VorbisOut1.FileName)
  else
    StatusBar1.Panels[0].Text := VorbisOut1.ExceptionMessage;
end;

procedure TForm1.VorbisOut1Progress(Sender: TComponent);
begin
  ProgressBar1.Position := VorbisOut1.Progress;
end;



procedure TForm1.FormCreate(Sender: TObject);
begin
  VorbisOut1.Delay := 16 - TrackBar1.Position*5;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  VorbisOut1.Delay := 16 - TrackBar1.Position*5;
end;

end.
