(*
   This is AudioProcessor demo which many people asked me about.
   This demo acceps 16 bps input. If the input is mono it is left as is,
   if the input is stereo it is converted to mono.
   In order to use AudioProcessor component you should set its OnGeData event
   handler at least.
   In this demo we also set OnGetChannels event handler
   Don't forget to assign WaveIn1's FileName property.
   (c) Andrei Borovsky, anb@symmetrica.net
*)

unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ACS_Classes, ACS_Misc, ACS_Wave, ACS_DXAudio, ACS_Types,
  StdCtrls;

type
  TForm1 = class(TForm)
    DXAudioOut1: TDXAudioOut;
    WaveIn1: TWaveIn;
    AudioProcessor1: TAudioProcessor;
    Button1: TButton;
    procedure AudioProcessor1GetData(Sender: TComponent; Data: Pointer;
      var n: Integer);
    procedure AudioProcessor1GetChannels(Sender: TComponent;
      var Param: Integer);
    procedure Button1Click(Sender: TObject);
    procedure DXAudioOut1Done(Sender: TComponent);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

(* Here Data is the poiner to the processor output data,
n - data length in bytes *)
procedure TForm1.AudioProcessor1GetData(Sender: TComponent; Data: Pointer;
  var n: Integer);
var
  PS16 : PStereoBuffer16; // We assume the input is 16 bits per sample
  P16 : PBuffer16;
  l, i : Integer;
begin
  if AudioProcessor1.Input.Channels = 1 then // if input is mono we simply pass it along
  begin
    n := AudioProcessor1.Input.GetData(Data, n);
  end else  //convert stereo to mono
  begin
    GetMem(PS16, n*2);
    l := AudioProcessor1.Input.GetData(PS16, n*2);
    P16 := Data;
    for i := 0 to (l div 4) - 1 do // one stereo sample -  4 bytes
    P16[i] := (PS16[i].Left + PS16[i].Right) div 2;
    n := l div 2;
    FreeMem(PS16);
  end;
end;

procedure TForm1.AudioProcessor1GetChannels(Sender: TComponent;
  var Param: Integer);
begin
  Param := 1; // always mono
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Self.DXAudioOut1.Run;
  Button1.Enabled := False;
end;

procedure TForm1.DXAudioOut1Done(Sender: TComponent);
begin
  Button1.Enabled := True;
end;

// This OnClose event prevents exceptions if he form is cosed while playing
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  DXAudioOut1.Stop;
  while DXAudioOut1.Status <> tosIdle do Sleep(5);
end;

end.
