unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ACS_DXAudio, StdCtrls, ComCtrls, ACS_Classes, ACS_Wave;

type
  TForm1 = class(TForm)
    WaveIn1: TWaveIn;
    WaveOut1: TWaveOut;
    TrackBar1: TTrackBar;
    TrackBar2: TTrackBar;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    Label2: TLabel;
    DXAudioOut1: TDXAudioOut;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    Button4: TButton;
    ProgressBar1: TProgressBar;
    procedure TrackBarChange(Sender: TObject);
    procedure Progress(Sender: TComponent);
    procedure Done(Sender: TComponent);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.TrackBarChange(Sender: TObject);
begin
  if TrackBar1.Position >  TrackBar2.Position then
    TrackBar1.Position :=  TrackBar2.Position;
end;

procedure TForm1.Progress(Sender: TComponent);
begin
  ProgressBar1.Position := (Sender as TAuOutput).Progress;
end;

procedure TForm1.Done(Sender: TComponent);
begin
  Button1.Enabled := True;
  Button2.Enabled := True;
  Button3.Enabled := True;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
     WaveIn1.FileName := OpenDialog1.FileName;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
  begin
    if WaveIn1.Valid then
    begin
      WaveOut1.FileName := SaveDialog1.FileName;
      Button1.Enabled := False;
      Button2.Enabled := False;
      Button3.Enabled := False;
      WaveIn1.StartSample := Round(WaveIn1.TotalSamples * TrackBar1.Position / 100);
      WaveIn1.EndSample := Round(WaveIn1.TotalSamples * TrackBar2.Position / 100);
      WaveOut1.Run;
    end;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if WaveIn1.Valid then
  begin
    Button1.Enabled := False;
    Button2.Enabled := False;
    Button3.Enabled := False;
    WaveIn1.StartSample := Round(WaveIn1.TotalSamples * TrackBar1.Position / 100);
    WaveIn1.EndSample := Round(WaveIn1.TotalSamples * TrackBar2.Position / 100);
    DXAudioOut1.Run;
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  DXAudioOut1.Stop;
end;

end.
