(*
  This file is a part of New Audio Components package v 1.0
  Copyright (c) 2002-2007, Andrei Borovsky. All rights reserved.
  See the LICENSE file for more details.
  You can contact me at anb@symmetrica.net
*)

(* $Revision: 1.4 $ $Date: 2007/07/27 09:01:04 $ *)

unit ACS_Types;

interface

type

  TBuffer16 = array[0..0] of SmallInt;
  PBuffer16 = ^TBuffer16;

  TBuffer8 = array[0..0] of Byte;
  PBuffer8 = ^TBuffer8;

  TStereoSample16 = packed record
    Left, Right : SmallInt;
  end;

  TStereoBuffer16 = array[0..0] of TStereoSample16;
  PStereoBuffer16 = ^TStereoBuffer16;

  TStereoSample8 = packed record
    Left, Right : Byte;
  end;

  TStereoBuffer8 = array[0..0] of TStereoSample8;
  PStereoBuffer8 = ^TStereoBuffer8;


  TComplex = packed record
    Re, Im : Double;
  end;

  PComplex = ^TComplex;

  TComplexArray = array[0..0] of TComplex;
  PComplexArray = ^TComplexArray;

  TDoubleArray = array[0..0] of Double;
  PDoubleArray = ^TDoubleArray;

  TStereoSampleD = record
    Left : Double;
    Right : Double;
  end;

  TStereoBufferD = array[0..0] of TStereoSampleD;
  PStereoBufferD = ^TStereoBufferD;

  TSmallIntArray = array[0..0] of SmallInt;
  PSmallIntArray = ^TSmallIntArray;

  Int24 = packed record
    b1, b2 : Byte;
    b3 : Byte;
  end;
  PInt24 = ^Int24;

  TBuffer24 = packed array[0..0] of Int24;
  PBuffer24 = ^TBuffer24;


  TSample8 = array[0..0] of Byte;
  PSample8 = ^TSample8;

  TAudioBuffer8 = array[0..0] of TSample8;
  PAudioBuffer8 = ^TAudioBuffer8;

  TSample16 = array[0..0] of SmallInt;
  PSample16 = ^TSample16;

  TAudioBuffer16 = array[0..0] of TSample16;
  PAudioBuffer16 = ^TAudioBuffer16;

  TSample24 = array[0..0] of Int24;
  PSample24 = ^TSample24;

  TAudioBuffer24 = array[0..0] of TSample24;
  PAudioBuffer24 = ^TAudioBuffer24;

  TSingleArray = array[0..0] of Single;
  PSingleArray = ^TSingleArray;

  TMSConverterMode = (msmMonoToBoth, msmMonoToLeft, msmMonoToRight);

const

  Pi = 3.14159265359;
  TwoPi = 6.28318530718;
  HalfPi = 1.57079632679;

implementation

end.
